// Copyright 2003 Macromedia, Inc. All rights reserved.

//******************* API **********************
//-------------------------------------------------------------------
// FUNCTION:
//   canAcceptCommand()
//
// DESCRIPTION: 
//   Determines whether the menu item should be active or dimmed. 
//
// ARGUMENTS:
//   none
//
// RETURNS:
//   Boolean value that indicates whether the item should be enabled.
//--------------------------------------------------------------------

function canAcceptCommand()
{
  // Get the DOM 
  var theDOM = dw.getDocumentDOM();
  
  if (theDOM == null)
	return false;
	
  // Get the offsets of the selection
  var theSel = theDOM.source.getSelection();
  if(theSel[0] != theSel[1])  
    return true;  
  else
    return false;
}

//-------------------------------------------------------------------
// FUNCTION:
//   receiveArguments()
//
// DESCRIPTION: 
//  Processes any arguments that are passed from a menuitem item.
//
// ARGUMENTS:
//   none
//
// RETURNS:
//   nothing
//-----------------------------------------------------------------

function receiveArguments()
{
    changeTagCase(arguments[0]);
}

//-------------------------------------------------------------------
// FUNCTION:
//   setMenuText()
//
// DESCRIPTION: 
//   Specifies the text that should appear in the menu.
//
// ARGUMENTS:
//   none
//
// RETURNS:
//   The string that should appear in the menu.

//-------------------------------------------------------------------
function setMenuText()
{
  if (arguments[0] == "tagToLowerCase")
    return Menu_HC_TagsToLowercase;
  else if(arguments[0] == "tagToUpperCase")
    return Menu_HC_TagsToUppercase;
}

//***************    LOCAL FUNCTIONS   ***************
//--------------------------------------------------------------------
// FUNCTION:
//   changeTagCase()
//
// DESCRIPTION:
//   changes case of the tag.
//
// ARGUMENTS:
//   tagCaseType - case type, Upper or Lower case
//
// RETURNS:
//   nothing
//
//--------------------------------------------------------------------

function changeTagCase(tagCaseType)
{
  // Get the DOM
  var theDOM = dw.getDocumentDOM();
  // Get the offsets of the selection
  var theSel = theDOM.source.getSelection();
  
  // Get the outerHTML of the HTML tag (the
  // entire contents of the document)
  var theDocEl = theDOM.documentElement;
  var theWholeDoc = theDocEl.outerHTML;
  var selText = theDOM.source.getText(theSel[0],theSel[1]);
 
  //Get first index of opening tag
  var openTagIndex = selText.indexOf("<");
  var nextOpenTagIndex;
  var closingTagIndex;
 
  //iterate until opening tag exists
  while(openTagIndex != -1)
  {    
    //skip if tag is PHP (<? ?>) or ASP/JSP (<% %>)
    if (selText.charAt(openTagIndex + 1) == "?" || selText.charAt(openTagIndex + 1) == "%")
    {
      openTagIndex = selText.indexOf("<",openTagIndex + 1);
      continue;
    }

    //get the first closing tag index after first opening tag
    closingTagIndex = selText.indexOf(">",openTagIndex + 1);
    //get the next opening tag index after first opening tag
    nextOpenTagIndex = selText.indexOf("<",openTagIndex + 1);
    //change the tag case
    if((closingTagIndex != -1) && (nextOpenTagIndex != -1))
    {
      if(closingTagIndex < nextOpenTagIndex)
      {
        selText = changeCase(selText,openTagIndex,closingTagIndex,tagCaseType);	  
	openTagIndex = selText.indexOf("<", openTagIndex + 1);
      }
      else
      {
        selText = changeCase(selText,openTagIndex,nextOpenTagIndex,tagCaseType);
	openTagIndex = selText.indexOf("<", nextOpenTagIndex + 1);
      }
    }      
    else if(closingTagIndex != -1)
    {
      selText = changeCase(selText,openTagIndex,closingTagIndex,tagCaseType);      
      openTagIndex = selText.indexOf("<", openTagIndex + 1);
    }
    else if(nextOpenTagIndex != -1)
    {
      selText = changeCase(selText,openTagIndex,nextOpenTagIndex,tagCaseType);      
      openTagIndex = selText.indexOf("<", nextOpenTagIndex + 1);
    }
    else
    {
      if(tagCaseType == "tagToLowerCase")
        selText = selText.substring(0,openTagIndex) + selText.substr(openTagIndex).toLowerCase();
      else if(tagCaseType == "tagToUpperCase")
        selText = selText.substring(0,openTagIndex) + selText.substr(openTagIndex).toUpperCase();
      
      openTagIndex = selText.indexOf("<", openTagIndex + 1);
    }    
  }    
  
  //replace the selected text with the modified text.
  if(dw.canShowDesignView(theDOM))
    theDocEl.outerHTML = theWholeDoc.substring(0,theSel[0]) + selText + theWholeDoc.substr(theSel[1]);
  else
    theDOM.source.replaceRange(theSel[0],theSel[1],selText);
    
  // Set the selection back to the starting point of selection
  theDOM.source.setSelection(theSel[1],theSel[1]);  
} 

//--------------------------------------------------------------------
// FUNCTION:
//   changeCase()
//
// DESCRIPTION:
//   changes case of the tag.
//
// ARGUMENTS:
//   selText - selected Text
//   openTagIndex - opening tag index
//   nextTagIndex - next opening or closing tag index.
//   tagCaseType - case type, Upper or Lower case
//
// RETURNS:
//   return - text with changed tag case.
//
//--------------------------------------------------------------------

function changeCase(selText,openTagIndex,nextTagIndex,tagCaseType)
{
  //change the tag case according to the tagCaseType.
  if(tagCaseType == "tagToLowerCase")
    selText = selText.substring(0,openTagIndex) + selText.substring(openTagIndex,nextTagIndex + 1).toLowerCase() + selText.substr(nextTagIndex + 1);
  else if(tagCaseType == "tagToUpperCase")
    selText = selText.substring(0,openTagIndex) + selText.substring(openTagIndex,nextTagIndex + 1).toUpperCase() + selText.substr(nextTagIndex + 1);
  
  return selText;
}
